import os
from pagure_backend_builder._vendor.pyyaml.lib import yaml

__all__ = [  
    'build_wheel',
]

def build_wheel(
        wheel_directory: str,
        config_settings: str = None,
        metadata_directory: str | None = None,):  

    config = load_yaml_config(os.path.join(metadata_directory,"pagure.yaml"))
    result_directory = os.path.join(os.path.abspath(wheel_directory),f"{config['project']['name']}-{config['project']['name']}.dist-info")

    # Build in a temporary directory, then copy to the target.
    os.makedirs(result_directory, exist_ok=True)    

    # Generate the METADATA file in os.path.join(result_directory,"METADATA")
    return result_directory


def load_yaml_config(yaml_path: str) -> dict:
    """
    Loads and parses a YAML configuration file.

    Args:
        yaml_path (str): The file path to the YAML configuration file.

    Returns:
        dict: A dictionary containing the parsed YAML configuration.
    """
    with open(yaml_path, "r", encoding="utf-8") as f:
        return yaml.safe_load(f)


